# File : "mfPostprocess.tcl"
#                        Created : 2001-02-06 22:07:36
#              Last modification : 2001-02-14 00:00:00
# Author : Bernard Desgraupes
# e-mail : <berdesg@easynet.fr>
# www : <http://perso.easynet.fr/~berdesg/>
# Description : this file is part of the Metafont Mode package for 
# Alpha. See comments at the beginning of 'mfMode.tcl'.
# 


namespace eval Mf {}


# Procs to run the related programs
# =================================

# This proc calls up gftopk
# -------------------------
proc Mf::dopkProc {} {
    global mf_params MfmodeVars 
    switch $MfmodeVars(mfAppSig) {
	"CMT3" {
	    if {![file exists [file join $mf_params(outputfolder) $mf_params(gffile)]]} {
		alertnote "Can't find file $mf_params(gffile)."
		return
	    }
	    set mf_params(pkcmdline) "gftopk [file join $mf_params(outputfolder) $mf_params(gffile)]"
	    app::launchFore "CMTe"
	    set mf_params(pkcmdline) [curlyq $mf_params(pkcmdline)]
	    eval "AEBuild 'CMTe'" CMTX exec {----} [list $mf_params(pkcmdline)]
	}
	"OzMF" {
	    if {![file exists [file join $mf_params(mfwd) $mf_params(gffile)]]} {
		alertnote "Can't find file $mf_params(gffile). Check that the \"delete_gf\" flag in OzMetafont configs is set to false."
		return
	    }
	    app::launchFore "OzMF"
	    set filename [file join $mf_params(mfwd) $mf_params(gffile)]
	    AEBuild 'OzMF' aevt odoc ---- [tclAE::build::alis $filename]
	}
    }
}

# This proc calls up gftodvi
# --------------------------
proc Mf::dodviProc {} {
    global mf_params MfmodeVars
    switch $MfmodeVars(mfAppSig) {
	"CMT3" {
	    if {![file exists [file join $mf_params(outputfolder) $mf_params(gffile)]]} {
		alertnote "Can't find file $mf_params(gffile)."
		return
	    }
	    if {[app::isRunning CMTd]} {
		sendQuitEvent 'CMTd'
		alertnote "Click to convert [file tail $mf_params(gffile)] to dvi."
	    }
	    set mf_params(dvicmdline) "gftodvi [file join $mf_params(outputfolder) $mf_params(gffile)]"
	    app::launchFore "CMTd"
	    set mf_params(dvicmdline) [curlyq $mf_params(dvicmdline)]
	    eval "AEBuild 'CMTd'" CMTX exec {----} [list $mf_params(dvicmdline)]
	}
	"OzMF" {
	    # We should never arrive here. OzMetafont has no Apple Event to convert a gf file to dvi.
	    # The GfToDvi menu item is withdrawn from the ConvertFiles submenu with Oz.
	}
    }
}

# --------------------------------------------------------------------------------
# This proc calls up a previewer to view the dvi file produced by gftodvi.
# For CMaCTeX, if you prefer xdvi to dvipreview, change the signature from PIVD to CMT8
# --------------------------------------------------------------------------------
proc Mf::viewdviProc {} {
    global mf_params MfmodeVars
    switch $MfmodeVars(mfAppSig) {
	"CMT3" {
	    if {![file exists [file join $mf_params(outputfolder) $mf_params(basefilename).dvi]]} {
		alertnote "Can't find file $mf_params(basefilename).dvi."
		return
	    }
	    app::launchFore "PIVD"
	    set filename [file join $mf_params(outputfolder) $mf_params(basefilename).dvi]
	    AEBuild 'PIVD' aevt odoc ---- [tclAE::build::alis $filename]
	}
	"OzMF" {
	    if {![file exists [file join $mf_params(dirfilename) $mf_params(basefilename).dvi]]} {
		alertnote "Can't find file $mf_params(basefilename).dvi."
		return
	    }
	    app::launchFore "OTEX"
	    set filename [file join $mf_params(dirfilename) $mf_params(basefilename).dvi]
	    AEBuild 'OTEX' aevt odoc ---- [tclAE::build::alis $filename]
	}
    }
}

# This proc calls up CMacTeX dvips
# --------------------------------
proc Mf::dviToPsProc {} {
    global mf_params
    if {![file exists [file join $mf_params(outputfolder) $mf_params(basefilename).dvi]]} {
	alertnote "Can't find file $mf_params(basefilename).dvi."
	return
    }
    app::launchFore "CMT1"
    set cmdline "dvips [file join $mf_params(outputfolder) $mf_params(basefilename).dvi]"
    AEBuild 'CMT1' CMTX exec ---- [tclAE::build::TEXT $cmdline]
}


# The following procs call up tftopl, pltotf, vptovf and vftovp
# -------------------------------------------------------------
proc Mf::selectToPostProcess {} {
    global mf_params MfmodeVars
    switch $mf_params(convertidx) {
	0 {
	    if {$mf_params(converter)=="vftovp"} {
		catch {getfile "Select a vf file for $mf_params(converter)"}  mf_params(vffile)
		if {$mf_params(vffile) == ""} return
		# In the case of OzMetafont, only the vf file is necessary : the tfm file is supposed to be
		# in the right place in the TeX tree.
		if {$MfmodeVars(mfAppSig) == "CMT3"} {
		    catch {getfile "Select a tfm file for $mf_params(converter)"}  mf_params(tfmfile)
		    if {$mf_params(tfmfile) == ""} {
			return
		    }
		}
		Mf::setnames $mf_params(vffile)
		Mf::doVftoVplProc
	    } else {
		catch {getfile "Select a $mf_params(extension) file for $mf_params(converter)"} mf_params(postfile)
		if {$mf_params(postfile) == ""} {
		    return
		} else {
		    Mf::setnames $mf_params(postfile)
		    Mf::postProcOne
		}
	    }
	}
	1 {
	    catch {get_directory -p "Select a folder."} mf_params(postfolder)
	    if {$mf_params(postfolder) == ""} { return }
	    set mf_params(currentdir) $mf_params(postfolder)
	    Mf::postProcAll
	    set mf_params(prefixrmall) ""
	    menu::buildSome otherFiles
	}
	2 {
	    if {$mf_params(currentdir) == ""}  {
		alertnote "No folder currently selected"
		return
	    }
	    set mf_params(postfolder) $mf_params(currentdir)
	    Mf::postProcAll
	    set mf_params(prefixrmall) ""
	    menu::buildSome otherFiles
	}
	default {}
    }    
}

# Converting a single file
# ------------------------
proc Mf::postProcOne {} {
    global mf_params MfmodeVars
    switch $mf_params(converter) {
	"tftopl" {
	    set mf_params(convertSig) CMTk
	    Mf::doTfmPlProc tfm pl
	}
	"pltotf" {
	    set mf_params(convertSig) CMTj
	    Mf::doTfmPlProc pl tfm
	}
	"vptovf" {
	    Mf::doVplToVfProc
	}
    }
}

proc Mf::doTfmPlProc {lftext rtext} {
    global mf_params MfmodeVars mode
    switch $MfmodeVars(mfAppSig) {
	"CMT3" {
	    if {[app::isRunning $mf_params(convertSig)]} {
		sendQuitEvent '$mf_params(convertSig)'
		alertnote "Wait until $mf_params(converter) has quit then click to proceed."
	    }
	    if {$mf_params(mfset)} {
		set mf_params(mfwd) $mf_params(postfolder)
	    } else {
		set mf_params(mfwd) $mf_params(outputfolder)
	    }
	    set path $mf_params(mfwd)
	    if {$mf_params(postfile) != ""} {
		set mf_params(postfile) ""
	    } else {
		if {![file exists [file join $path $mf_params(basefilename).$lftext]]} {
		    alertnote "Can't find file $mf_params(basefilename).$lftext."
		    return
		}
	    }
	    set mf_params(cmdline) "$mf_params(converter) [file join $path $mf_params(basefilename).$lftext] \
	      [file join $path $mf_params(basefilename).$rtext]"
	    app::launchBack "$mf_params(convertSig)"
	    eval "AEBuild '$mf_params(convertSig)'" CMTX exec ---- [list [tclAE::build::TEXT $mf_params(cmdline)]]
	    alertnote "Processing file $mf_params(basefilename).$rtext. Click when processing is over."
	}
	"OzMF" {
	    if {$mf_params(mfset)} {
		set mf_params(mfwd) $mf_params(postfolder)
	    } else {
		set mf_params(mfwd) $mf_params(dirfilename)
	    }
	    set path $mf_params(mfwd)
	    if {![file exists [file join $path $mf_params(basefilename).$lftext]]} {
		alertnote "Can't find file $mf_params(basefilename).$lftext. Check that the \"delete_tfm\" flag \
		  in OzMetafont configs is set to false."
		return
	    }
	    app::launchFore "OzMF"
	    if {$mf_params(postfile) != ""} {
		set mf_params(postfile) ""
	    } 
	    set filename [file join $path $mf_params(basefilename).$lftext]
	    AEBuild 'OzMF' aevt odoc ---- [tclAE::build::alis $filename]
	    AEBuild 'OzMF' aevt quit
	}
    }
    if {$rtext=="pl" && [file exists [file join $path $mf_params(basefilename).$rtext]]} {
	edit [file join $path $mf_params(basefilename).$rtext]
	changeMode Mf
    } 
}

proc Mf::doVftoVplProc {} {
    global mf_params MfmodeVars 
    switch $MfmodeVars(mfAppSig) {
	"CMT3" { 	
	    if {[app::isRunning CMTl]} {
		sendQuitEvent 'CMTl'
		alertnote "Wait until $mf_params(converter) has quit then click to proceed."
	    }
	    set mf_params(cmdline) "$mf_params(converter) $mf_params(vffile) $mf_params(tfmfile) \
	      [file join $mf_params(dirfilename) $mf_params(basefilename).vpl]"
	    set mf_params(postfile) ""
	    app::launchBack "CMTl"
	    eval "AEBuild 'CMTl'" CMTX exec ---- [list [tclAE::build::TEXT $mf_params(cmdline)]]
	    if {[file exists [file join $mf_params(dirfilename) $mf_params(basefilename).vpl]]} {
		edit [file join $mf_params(dirfilename) $mf_params(basefilename).vpl]
	    } 
	}
	"OzMF" {
	    app::launchFore "OzMF"
	    AEBuild 'OzMF' aevt odoc ---- [tclAE::build::alis $mf_params(vffile)]
	}
    }
}

proc Mf::doVplToVfProc {} {
    global mf_params MfmodeVars 
    switch $MfmodeVars(mfAppSig) {
	"CMT3" { 	
	    if {[app::isRunning CMTm]} {
		sendQuitEvent 'CMTm'
		alertnote "Wait until $mf_params(converter) has quit then click to proceed."
	    }
	    if {$mf_params(mfset)} {
		set mf_params(mfwd) $mf_params(postfolder)
	    } else {set mf_params(mfwd) $mf_params(outputfolder)}
	    if {$mf_params(postfile) != ""} {
		set mf_params(cmdline) "$mf_params(converter) [file join $mf_params(dirfilename) $mf_params(basefilename).vpl] \
		  [file join $mf_params(dirfilename) $mf_params(basefilename).vf] \
		  [file join $mf_params(dirfilename) $mf_params(basefilename).tfm]"
		set mf_params(postfile) ""
	    } else {
		if {![file exists [file join $mf_params(mfwd) $mf_params(basefilename).vpl]]} {
		    alertnote "Can't find file $mf_params(basefilename).vpl."
		    return
		}
		set mf_params(cmdline) "$mf_params(converter) [file join $mf_params(mfwd) $mf_params(basefilename).vpl] \
		  [file join $mf_params(mfwd) $mf_params(basefilename).vf] \
		  [file join $mf_params(mfwd) $mf_params(basefilename).tfm]"
	    }
	    app::launchFore "CMTm"
	    set mf_params(cmdline) [curlyq $mf_params(cmdline)]
	    eval "AEBuild 'CMTm'" CMTX exec {----} [list $mf_params(cmdline)]
	    alertnote "Processing file $mf_params(basefilename).vpl. Click when processing is over."
	}
	"OzMF" {
	    if {$mf_params(mfset)} {
		set mf_params(mfwd) $mf_params(postfolder)
	    } else {set mf_params(mfwd) $mf_params(dirfilename)}
	    if {![file exists [file join $mf_params(mfwd) $mf_params(basefilename).vpl]]} {
		alertnote "Can't find file $mf_params(basefilename).vpl."
		return
	    }
	    app::launchFore "OzMF"
	    if {$mf_params(postfile) != ""} {
		set filename $mf_params(postfile)				
		set mf_params(postfile) ""
	    } else {
		set filename [file join $mf_params(mfwd) $mf_params(basefilename).vpl]
		app::launchFore "ALFA"
	    }
	    AEBuild 'OzMF' aevt odoc ---- [tclAE::build::alis $filename]
	    AEBuild 'OzMF' aevt quit
	}
    }
}

# Converting an entire folder
# ---------------------------
proc Mf::postProcAll {} {
    global mf_params MfmodeVars
    switch $mf_params(converter) {
	"tftopl" {
	    set mf_params(convertSig) CMTk
	    Mf::doTfmPlAllProc tfm pl
	    }
	"pltotf" {
	    set mf_params(convertSig) CMTj
	    Mf::doTfmPlAllProc pl tfm
	}
	"vptovf" {
	    Mf::doVplToVfAllProc
	}
    }
}

proc Mf::doTfmPlAllProc {lftext rtext} {
    global mf_params MfmodeVars
    set mf_params(mfset) 1
    set filesindir [glob -nocomplain -dir [file join $mf_params(postfolder)] *.$lftext]
    if {[llength $filesindir] == 0} {
	alertnote "No \".$lftext\" file in this folder."
	set mf_params(mfset) 0
	return
    } 
    switch [buttonAlert "Process all $lftext files in $mf_params(postfolder) with $mf_params(converter) ? " "yes" "cancel" ] {
	"yes" {
	    foreach file $filesindir {
		set mf_params(postfile) $file
		Mf::setnames $file
		Mf::doTfmPlProc $lftext $rtext
	    }
	}
	"cancel" {}
    }
    set mf_params(mfset) 0
    menu::buildSome convertFiles
}


proc Mf::doVplToVfAllProc {} {
    global mf_params
    set mf_params(mfset) 1
    set filesindir [glob -nocomplain -dir [file join $mf_params(postfolder)] *.vpl]
    if {[llength $filesindir] == 0} {
	alertnote "No \"vpl\" file in this folder."
	set mf_params(mfset) 0
	return
    } 
    switch [buttonAlert "Process all the vpl files in $mf_params(postfolder) with vptovf ? " "yes" "cancel" ] {
	"yes" {
	    foreach f $filesindir {
		Mf::setnames $f
		Mf::doVplToVfProc
	    }
	}
	"cancel" {}
    }
    set mf_params(mfset) 0
    menu::buildSome convertFiles
}


# Editing output files
# --------------------
proc Mf::editlogProc {}  {
    global mf_params MfmodeVars
    switch $MfmodeVars(mfAppSig) {
	"CMT3" { 	
	    set path $mf_params(outputfolder)
	    set mess "Can't find file $mf_params(basefilename).log."
	}
	"OzMF" {
	    set path $mf_params(dirfilename)
	    set mess "Can't find file $mf_params(basefilename).log. \
	      Check that the \"delete_log\" flag in OzMetafont configs is set to false."
	}
    }
    if {![file exists [file join $path $mf_params(basefilename).log]]} {
	alertnote $mess
	return
    } else {
	edit -r [file join $path $mf_params(basefilename).log]
    }
}

proc Mf::editplProc {} {
    global mf_params MfmodeVars
    switch $MfmodeVars(mfAppSig) {
	"CMT3" { 	
	    set path $mf_params(outputfolder)
	}
	"OzMF" {
	    set path $mf_params(dirfilename)
	}
    }
    if {[file exists [file join $path $mf_params(basefilename).pl]]} {
	edit -r [file join $path $mf_params(basefilename).pl]
    } else {
	alertnote "Can't find $mf_params(basefilename).pl in $path."
    }
    changeMode Mf
    set mf_params(prefixpl) ""
    Mf::rebuildSubmenus ""
}


